###############################################################
# R code: Exercise 9.2(b)
# File: AVAS-estimation-forecasting.r
# 
# INPUT: 
# pset   = size of prediction set (here 12)
# p      = Markov order (here 2)  
#
# OUTPUT: 
# Ypred  = (pset * 1) vector of one-step ahead forecasts  
###############################################################
library(acepack)
zGSL   <- scale(GSL519) # standardized data
zGSLt  <- ts(zGSL)
nr     <- length(zGSLt)
p      <- 2    # lag length (Markov order)
pset   <- 12 
n      <- nr-pset-p 
lagmat <- function(x,max.lag)embed(c(rep(NA,max.lag),x),max.lag+1)
xlag   <- lagmat(zGSLt,p) 

Ycmat1  <- matrix(0,nrow=pset,ncol=1)
Ypred   <- matrix(0,nrow=pset,ncol=1)
for (i in 1:pset){
  Xactual1   <- window(xlag[3:nr,2],end=n+i)
  Yactual1   <- window(xlag[3:nr,1],end=n+i)
  avasout1   <- avas(Xactual1,Yactual1)   
  Ypred1     <- avasout1$ty[n+i]
  Ycmat1[i,] <- Ypred1        # 1-step ahead forecast, 1st lag
  
  Xactual2   <- window(xlag[3:nr,3],end=n+i)
  Yactual2   <- window(xlag[3:nr,1],end=n+i)
  avasout2   <- avas(Xactual2,Yactual2)   
  Ypred2     <- avasout2$ty[n+i]
  Ypred[i,]  <- Ypred2+Ypred1 # 1-step ahead forecast, 
                              # 1st and 2nd lag
}